#include <iostream>
#include <vector>
#include <set>

constexpr int32_t MAX_N = 200000;

// sa dva multiseta cuvamo najveci i najmanji x elementi
std::multiset<int64_t> lowest_x, highest_rest;
int64_t lowest_sum = 0;
int32_t lowest_limit_size = 0;

[[gnu::hot]]
void add_value(int64_t value) noexcept {
	lowest_x.insert(value);
	lowest_sum += value;

	// pomeramo ako je velicina previse velika
	if ((int32_t)lowest_x.size() > lowest_limit_size) {
		auto it = lowest_x.end();
		--it; // zadnja vrednost

		lowest_sum -= *it;
		highest_rest.insert(*it);
		lowest_x.erase(it);
	}

	// max od lowest mora da bude manji od minimum od highest
	if (!lowest_x.empty() && !highest_rest.empty()) {
		auto it_low = lowest_x.end(); it_low--;
		auto it_high = highest_rest.begin();

		if (*it_low > *it_high) {
			int64_t pom1 = *it_low;
			int64_t pom2 = *it_high;

			lowest_x.erase(it_low);
			lowest_sum -= pom1;
			highest_rest.erase(it_high);

			lowest_x.insert(pom2);
			lowest_sum += pom2;
			highest_rest.insert(pom1);
		}
	}
}

[[gnu::hot]]
void remove_value(int64_t value) noexcept {
	// prvo trazimo u high
	auto it_high = highest_rest.find(value);
	if (it_high != highest_rest.end()) {
		highest_rest.erase(it_high);
	} else {
		// ako nije u high onda je u low
		auto it_low = lowest_x.find(value);
		if (it_low != lowest_x.end()) {
			lowest_x.erase(it_low);
			lowest_sum -= value;

			// onda ubacujemo novi element iz high
			// posto smo sad izbacili iz low
			if (!highest_rest.empty()) {
				auto it_move = highest_rest.begin();
				lowest_sum += *it_move;
				lowest_x.insert(*it_move);
				highest_rest.erase(it_move);
			}
		}
	}
}

int main() noexcept {
	std::ios::sync_with_stdio(false);
	std::cin.tie(nullptr);
	std::cout.tie(nullptr);
	std::cerr.tie(nullptr);

	int32_t n, k, x, i;
	std::cin >> n >> k >> x;

	std::vector<int64_t> niz(n);
	std::vector<int64_t> prefix(n);

	for(i = 0; i < n; ++i)
		std::cin >> niz[i];

	prefix[0] = niz[0];
	for(i = 1; i < n; ++i)
		prefix[i] = niz[i] + prefix[i-1];

	// maksimalne suffix sume su jednake minimalnim prefix sumama
	lowest_limit_size = x - 1;

	// onda sliding window za prva k elementa
	for(i = 0; i < k; ++i)
		add_value(prefix[i]);

	// sliding window
	for(i = 0; i < n - k + 1; ++i) {
		int64_t end = i + k - 1;
		int64_t base_sum = prefix[end] - (i > 0 ? prefix[i-1] : 0);

		// maksimalan bonus se nalazi tamo gde nam je prefix od j najmanji
		int64_t bonus = (int64_t)(x - 1) * prefix[end] - lowest_sum;

		std::cout << base_sum + bonus << (i == n - k ? "" : " ");

		// sad samo pomerimo window tako sto izbacimo nulti index
		// i dodamo sledeci index, za optimalno resenje?
		if (i < n - k) {
			remove_value(prefix[i]);
			add_value(prefix[i + k]);
		}
	}
}